"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropertyAnimator = void 0;
class PropertyAnimator {
    constructor(options) {
        this.animationEvent = null;
        this.animationTime = 0.0;
        this.startValue = 0.0;
        this.endValue = 1.0;
        this.scriptC = options.scriptComponent;
        this.duration = options.defaultDuration;
        this.easing = options.easing || ((t) => t);
    }
    setupAnimation(getter, setter, lerp) {
        this.getter = getter;
        this.setter = setter;
        this.lerp = lerp;
    }
    configure(config, options) {
        if (Array.isArray(options)) {
            config.configureArray(this, options);
        }
        else {
            config.configure(this, options);
        }
    }
    setCallbackOnFinish(cb) {
        this.callbackOnFinish = cb;
    }
    startAnimation(endValue, duration) {
        this.endValue = endValue;
        this.startValue = this.getter();
        this.duration = duration || this.duration;
        this.animationTime = 0;
        this.removeAnimationEvent();
        this.animationEvent = this.scriptC.createEvent('UpdateEvent');
        this.animationEvent.bind((ev) => this.update(ev));
    }
    update(eventData) {
        this.animationTime += eventData.getDeltaTime();
        const t = Math.min(this.animationTime / this.duration, 1);
        const easedT = this.easing(t);
        const value = this.lerp(this.startValue, this.endValue, easedT);
        this.setter(value);
        if (t >= 1) {
            this.removeAnimationEvent();
            this.callbackOnFinish && this.callbackOnFinish();
        }
    }
    removeAnimationEvent() {
        if (this.animationEvent) {
            this.scriptC.removeEvent(this.animationEvent);
            this.animationEvent.enabled = false;
            this.animationEvent = null;
        }
    }
}
exports.PropertyAnimator = PropertyAnimator;
//# sourceMappingURL=PropertyAnimator.js.map